% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{uniformcrossover}
\alias{uniformcrossover}
\title{Uniform crossover to produce offsprings}
\usage{
uniformcrossover(mom, dad, prange, minDist, lmax, N)
}
\arguments{
\item{mom}{Among two selected individuals, \code{mom} represents the selected
chromosome representation with lower fitness function value.}

\item{dad}{Among two selected individuals, \code{dad} represents the selected
chromosome representation with larger fitness function value.}

\item{prange}{Default value is \code{NULL} for only changepoint detection. If
\code{prange} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{prange}.}

\item{minDist}{The required minimum distance between two adjacent changepoints.}

\item{lmax}{The user specified maximum number of changepoints, by default,
as \code{N/2 - 1}.}

\item{N}{The length of time series.}
}
\value{
The child chromosome that produced from \code{mom} and \code{dad} for
next generation.
}
\description{
In uniform crossover, typically, each bit is chosen from either parent with
equal probability. Other mixing ratios are sometimes used, resulting in
offspring which inherit more genetic information from one parent than the
other. In a uniform crossover, we don’t divide the chromosome into segments,
rather we treat each gene separately. In this, we essentially flip a coin
for each chromosome to decide whether or not it will be included in the
off-spring. If model order selection is requested, each child's model order
has the equal probability (0.5) from \code{dad} and \code{mom}.
}
