% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{ageprof}
\alias{ageprof}
\title{Build Age-Profile Plot by Sex}
\usage{
ageprof(data, log_scale = FALSE, color = "Fresh and bright")
}
\arguments{
\item{data}{A data frame of population data for a specific province and year,
containing at least the variables:
\code{pop} (population count),
\code{sex} (coded as 1 = male, 2 = female),
\code{age5} (5-year age groups).}

\item{log_scale}{Logical; whether to use a logarithmic scale for the Y-axis.
Default is \code{FALSE}.}

\item{color}{Character; the name of a Canva color palette available in
\code{ggthemes::canva_palettes}. Default is \code{"Fresh and bright"}.}
}
\value{
A \code{ggplot2} object representing the age-profile plot, faceted by sex.
}
\description{
Create a line plot of population age profiles (5-year age groups) for a given
province and year, with optional logarithmic scale. The plot is faceted by sex.
}
\details{
The function produces an age-profile line chart where:
\itemize{
\item X-axis: Age (5-year groups).
\item Y-axis: Population counts (in thousands by default).
\item Separate lines are drawn for males and females.
\item Users can choose logarithmic scaling of the Y-axis.
}
}
\examples{
\dontrun{
# Example: age profile for Indonesia, 2020
data_idn <- pop_data_by_year(load_pop_data(), 2020) |>
  pop_data_by_reg(0) # Indonesia
ageprof(data_idn)

# Example with log scale
ageprof(data_idn, log_scale = TRUE)
}

}
\seealso{
\code{\link[=pyr_single]{pyr_single()}}, \code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}, \code{\link[=pop_data_by_year]{pop_data_by_year()}}, \code{\link[=get_code_label]{get_code_label()}}
}
