% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_curvygau}
\alias{make_curvygau}
\title{Generate Curvy Quadratic and Gaussian Clusters}
\usage{
make_curvygau(n = c(200, 100), p = 4)
}
\arguments{
\item{n}{A numeric vector of length 2, specifying the number of
observations in each cluster. All values must be positive.}

\item{p}{Integer. Number of dimensions. Must be at least 3.}
}
\value{
A tibble containing \eqn{n[1] + n[2]} rows and \eqn{p} columns,
  with generated features (\code{x1, x2, ..., xp}) and a
  \code{cluster} label.
}
\description{
This function generates synthetic high-dimensional data containing
two clusters: one quadratic-shaped cluster and one Gaussian-shaped
cluster. The clusters are positioned apart in feature space with
different scaling factors.
}
\examples{
# Generate 2 clusters in 4D: one quadratic, one Gaussian
curvygau <- make_curvygau()

}
