% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_commit}
\alias{btw_tool_git_commit}
\title{Tool: Git Commit}
\usage{
btw_tool_git_commit(message, files = NULL, `_intent` = "")
}
\arguments{
\item{message}{A commit message describing the changes.}

\item{files}{Optional character vector of file paths to stage and commit.
Use \code{"."} to stage all changed files. If \code{NULL}, commits currently staged files.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns the commit SHA.
}
\description{
This tool allows an LLM stage files and create a git commit. This tool uses a
combination of \code{\link[gert:git_commit]{gert::git_add()}} to stage files and \code{\link[gert:git_commit]{gert::git_commit()}} to
commit them, which is equivalent to \verb{git add} and \verb{git commit} in the
terminal, respectively.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  writeLines("hello, world", "hello.md")

  res <- btw_tool_git_commit("Initial commit", files = "hello.md")

  # What the LLM sees
  cat(res@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_checkout}()},
\code{\link{btw_tool_git_branch_create}()},
\code{\link{btw_tool_git_branch_list}()},
\code{\link{btw_tool_git_diff}()},
\code{\link{btw_tool_git_log}()},
\code{\link{btw_tool_git_status}()}
}
\concept{git tools}
