% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_list_records.R
\name{bs_list_records}
\alias{bs_list_records}
\title{List records in a repo}
\usage{
bs_list_records(
  repo,
  collection,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{repo}{Character, length 1. The handle or DID of the repo.}

\item{collection}{Character, length 1. The NSID of the record collection.}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of record information
}
\description{
List records in a repo
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-25)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_list_records(repo = 'chriskenny.bsky.social', collection = 'app.bsky.feed.post')
\dontshow{\}) # examplesIf}
}
\concept{repo}
