% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_surv_sim.R
\name{ext_surv_sim}
\alias{ext_surv_sim}
\title{Create an external survival data based on expert opinion}
\usage{
ext_surv_sim(t_info, S_info, T_max, n = 100)
}
\arguments{
\item{t_info}{A vector of times for which expert opinion is elicited}

\item{S_info}{A vector of mean survival probabilities estimated by experts
corresponding to time points in \code{t_info}}

\item{T_max}{The maximum survival time to be used}

\item{n}{The number of patients to construct the artificial external data set; default 100}
}
\value{
Dataframe of times and censoring status
}
\description{
Generally, the sampling is done is two steps
\deqn{
   p(T) = p(T | interval i) p(interval i)
}
}
\details{
In particular
\eqn{T ~ U(x_{i}, x_{i+1})}
\eqn{i ~ multinomial(\hat{\pi})}
}
\examples{
dat <- ext_surv_sim(t_info = c(10,20,50),
                    S_info = c(0.9, 0.8, 0.2),
                    T_max = 100, n = 100)
if (require(survival)) {
    km_fit <- survfit(Surv(time, event) ~ 1, data = dat)
    plot(km_fit)
}
}
