% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-funs.R
\name{is_hosted_session}
\alias{is_hosted_session}
\title{Detect if running in a hosted session}
\usage{
is_hosted_session()
}
\value{
A logical value: \code{TRUE} if running in a hosted session (Google Colab
or remote RStudio Server), \code{FALSE} otherwise.
}
\description{
Determines whether the current R session is running in a hosted environment
such as Google Colab or RStudio Server (non-localhost).
}
\details{
This function checks for:
\itemize{
\item Google Colab: presence of the \code{COLAB_RELEASE_TAG} environment variable
\item RStudio Server: \code{RSTUDIO_PROGRAM_MODE} is "server" and
\code{RSTUDIO_HTTP_REFERER} does not contain "localhost"
}
}
\examples{
if (is_hosted_session()) {
  message("Running in a hosted environment")
}
}
