% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdbiDriver.R, R/dbConnect_AdbiDriver.R,
%   R/dbDisconnect_AdbiConnection.R
\name{adbi}
\alias{adbi}
\alias{dbConnect_AdbiDriver}
\alias{dbConnect,AdbiDriver-method}
\alias{dbDisconnect_AdbiConnection}
\alias{dbDisconnect,AdbiConnection-method}
\title{Adbi driver}
\usage{
adbi(driver = NA_character_)

\S4method{dbConnect}{AdbiDriver}(drv, ..., bigint = NULL)

\S4method{dbDisconnect}{AdbiConnection}(conn, force = getOption("adbi.force_close_results", FALSE), ...)
}
\arguments{
\item{driver}{A driver specification that can be evaluated (with no
arguments) to give an \code{\link[adbcdrivermanager:adbc_driver_void]{adbcdrivermanager::adbc_driver()}}. See Details for
more information.}

\item{drv}{An object that inherits from
\link[DBI:DBIDriver-class]{DBI::DBIDriver},
or an existing \link[DBI:DBIConnection-class]{DBI::DBIConnection}
object (in order to clone an existing connection).}

\item{...}{Extra arguments passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}} are forwarded to
\code{\link[adbcdrivermanager:adbc_database_init]{adbcdrivermanager::adbc_database_init()}}}

\item{bigint}{The R type that 64-bit integer types should be mapped to,
default is \link[bit64:bit64-package]{bit64::integer64}, if bit64 is installed and \code{character}
otherwise}

\item{conn}{A \link[DBI:DBIConnection-class]{DBI::DBIConnection} object,
as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{force}{Close open results when disconnecting}
}
\value{
A connection object (S4 class \code{AdbiCOnnection}, inheriting from
\link[DBI:DBIConnection-class]{DBI::DBIConnection}) is returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}, while
\code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}} returns \code{TRUE} invisibly.
}
\description{
In order to open a database connection, \code{\link[DBI:dbConnect]{DBI::dbConnect()}} dispatches on a
driver object, which can be instantiated by calling \code{adbi()}.
}
\details{
To specify the type of adbc driver, \code{adbi} accepts as \code{driver} argument
\itemize{
\item an object inheriting from \code{adbc_driver},
\item a function that can be evaluated with no arguments and returns an object
inheriting from \code{adbc_driver},
\item a string of the form \code{pkg::fun} (where \verb{pkg::} is optional and defaults
to \code{fun}), which can be used to look up such a function.
}

As default, an \code{\link[adbcdrivermanager:adbc_driver_monkey]{adbcdrivermanager::adbc_driver_monkey()}} object is created.
}
\examples{
adbi()
if (requireNamespace("adbcsqlite")) {
  adbi("adbcsqlite")
}
library(DBI)
con <- dbConnect(adbi())
dbIsValid(con)
dbDisconnect(con)
dbIsValid(con)
}
