% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{summary.XDNUTS}
\alias{summary.XDNUTS}
\title{Function to print the summary of an XDNUTS model.}
\usage{
\method{summary}{XDNUTS}(
  object,
  ...,
  q.val = c(0.05, 0.25, 0.5, 0.75, 0.95),
  which = NULL,
  which_chains = NULL
)
}
\arguments{
\item{object}{an object of class \code{XDNUTS}.}

\item{...}{additional arguments to customize the summary.}

\item{q.val}{desired quantiles of the posterior distribution for each coordinate.
Default values are \code{0.05,0.25,0.5,0.75,0.95}.}

\item{which}{either a numerical vector indicating the index of the parameters of interest or a string \describe{
\item{\code{which = 'continuous'}}{for plotting the first \eqn{d-k} parameters.}
\item{\code{which = 'discontinuous'}}{for plotting the last \eqn{k} parameters.}
}
where both \eqn{d} and \eqn{k} are elements contained in the output of the function \link{xdnuts}.}

\item{which_chains}{a numerical vector indicating the index of the chains of interest.}
}
\value{
a list containing a data frame named \code{stats} with the following columns: \describe{\item{mean}{the mean of the posterior distribution.}
\item{sd}{the standard deviation of the posterior distribution.}
\item{q.val}{the desired quantiles of the posterior distribution.}
\item{ESS}{the Effective Sample Size for each marginal distribution.}
\item{R_hat}{the Potential Scale Reduction Factor of Gelman \insertCite{gelman1992inference}{XDNUTS}, only if multiple chains are available.}
\item{R_hat_upper_CI}{the upper confidence interval for the latter, only if multiple chains are available.}
}
Other quantities returned are:\describe{
\item{Gelman.Test}{the value of the multivariate Potential Scale Reduction Factor test \insertCite{gelman1992inference}{XDNUTS}.}
\item{BFMI}{the value of the empirical Bayesian Fraction of Information Criteria \insertCite{betancourt2016diagnosing}{XDNUTS}. 
A value below 0.2 indicates a bad random walk behavior in the energy Markov Chain, mostly due to a suboptimal
specification of the momentum parameters probability density.}
\item{n_div}{the total number of trajectory ended with a divergent transition.}
\item{n_premature}{the total number of trajectory with a premature termination.}}
}
\description{
Function to print the summary of an XDNUTS model.
}
\references{
\insertAllCited{}
}
