% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/quantification.R
\name{AggregateTiles}
\alias{AggregateTiles}
\alias{AggregateTiles.Seurat}
\alias{AggregateTiles.ChromatinAssay}
\alias{AggregateTiles.default}
\title{Quantify aggregated genome tiles}
\usage{
AggregateTiles(object, ...)

\method{AggregateTiles}{Seurat}(
  object,
  genome,
  assay = NULL,
  new.assay.name = "tiles",
  min_counts = 5,
  binsize = 5000,
  verbose = TRUE,
  ...
)

\method{AggregateTiles}{ChromatinAssay}(
  object,
  genome,
  min_counts = 5,
  binsize = 5000,
  verbose = TRUE,
  ...
)

\method{AggregateTiles}{default}(
  object,
  genome,
  cells = NULL,
  min_counts = 5,
  binsize = 5000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object or ChromatinAssay object}

\item{...}{Additional arguments passed to other methods}

\item{genome}{genome A vector of chromosome sizes for the genome. This is
used to construct the genome bin coordinates. The can be obtained by calling
seqlengths on a BSgenome-class object.}

\item{assay}{Name of assay to use}

\item{new.assay.name}{Name of new assay to create containing aggregated
genome tiles}

\item{min_counts}{Minimum number of counts for a tile to be retained prior to
aggregation}

\item{binsize}{Size of the genome bins (tiles) in base pairs}

\item{verbose}{Display messages}

\item{cells}{Cells to include}
}
\value{
When running on a Seurat object, returns the Seurat object with a new
\code{\link{ChromatinAssay}} added.

When running on a \code{\link{ChromatinAssay}}, returns a new
\code{ChromatinAssay} containing the aggregated genome tiles.

When running on a fragment file, returns a sparse region x cell
matrix.
}
\description{
Quantifies fragment counts per cell in fixed-size genome bins across the
whole genome, then removes bins with less than a desired minimum number of
counts in the bin, then merges adjacent tiles into a single region.
}
\concept{quantification}
