% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictAndSimulate.R
\name{predictSLGP_cdf}
\alias{predictSLGP_cdf}
\title{Predict cumulative distribution values at new locations using a SLGP model}
\usage{
predictSLGP_cdf(
  SLGPmodel,
  newNodes,
  interpolateBasisFun = "WNN",
  nIntegral = 101,
  nDiscret = 101
)
}
\arguments{
\item{SLGPmodel}{An object of class \code{\link{SLGP-class}}.}

\item{newNodes}{A data frame with covariate values where the SLGP should be evaluated.}

\item{interpolateBasisFun}{Character string indicating the interpolation scheme for basis functions:
one of \code{"nothing"}, \code{"NN"}, or \code{"WNN"} (default).}

\item{nIntegral}{Number of integration points along the response axis.}

\item{nDiscret}{Discretization resolution for interpolation (optional).}
}
\value{
A data frame with \code{newNodes} and predicted CDF values, columns named \code{cdf_1}, \code{cdf_2}, ...
}
\description{
Computes the posterior cumulative distribution function (CDF) values at specified
covariate values using a fitted SLGP model.
}
\examples{
\donttest{
# Load Boston housing dataset
library(MASS)
data("Boston")
# Set input and output ranges manually (you can also use range(Boston$age), etc.)
range_x <- c(0, 100)
range_response <- c(0, 50)

#' #Create a SLGP model but don't fit it
modelPrior <- slgp(medv ~ age,        # Use a formula to specify response and covariates
                 data = Boston,     # Use the original Boston housing data
                 method = "none",    # No training
                 basisFunctionsUsed = "RFF",         # Random Fourier Features
                 sigmaEstimationMethod = "heuristic",  # Auto-tune sigma2 (more stable)
                 predictorsLower = range_x[1],         # Lower bound for 'age'
                 predictorsUpper = range_x[2],         # Upper bound for 'age'
                 responseRange = range_response,       # Range for 'medv'
                 opts_BasisFun = list(nFreq = 200,     # Use 200 Fourier features
                                      MatParam = 5/2), # Matern 5/2 kernel
                 seed = 1)                             # Reproducibility

#Let us make 3 draws from the prior
nrep <- 3
set.seed(8)
p <- ncol(modelPrior@coefficients)
modelPrior@coefficients <- matrix(rnorm(n=nrep*p), nrow=nrep)

# Where to predict the field of pdfs ?
dfGrid <- data.frame(expand.grid(seq(range_x[1], range_x[2], 5),
seq(range_response[1], range_response[2],, 101)))
colnames(dfGrid) <- c("age", "medv")
predPriorcdf <- predictSLGP_cdf(SLGPmodel=modelPrior,
                                newNodes = dfGrid)
}
}
