% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLGP-package.R
\docType{package}
\name{SLGP-package}
\alias{SLGP-package}
\title{SLGP: A package for spatially dependent probability distributions}
\description{
The \code{SLGP} package implements Spatial Logistic Gaussian Processes (SLGP) for the flexible modeling
of conditional and spatially dependent probability distributions. The SLGP framework leverages
basis-function expansions and sample-based inference (e.g., MAP, Laplace, MCMC) for efficient
density estimation and uncertainty quantification. This package includes functionality to define,
train, and sample from SLGP models, as well as visualization and diagnostic tools.
}
\section{SLGP functions}{

The core functions in the package include:
\itemize{
\item \code{\link{slgp}}: trains an SLGP model from formula, data, and hyperparameters.
\item \code{\link{predictSLGP_moments}}: computes posterior predictive means and variances.
\item \code{\link{predictSLGP_quantiles}}: computes posterior predictive quantiles.
\item \code{\link{sampleSLGP}}: draws samples from the posterior predictive SLGP.
\item \code{\link{retrainSLGP}}: retrains a fitted SLGP object with new parameters or method.
}
}

\references{
Gautier, Athénaïs (2023). "Modelling and Predicting Distribution-Valued Fields with Applications to Inversion Under Uncertainty." Thesis, Universität Bern, Bern.
See the thesis online at \url{https://boristheses.unibe.ch/4377/}
}
\author{
\strong{Maintainer}: Athénaïs Gautier \email{athenais.gautier@onera.fr}

}
\keyword{internal}
