% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_new_reporting.R
\name{start_new_reporting}
\alias{start_new_reporting}
\title{Generate qmd, html and css files for reporting}
\usage{
start_new_reporting(
  folder_path,
  output_folder,
  name = "report",
  structure = "USMR",
  path_logo = NULL,
  confidential = FALSE,
  report_type = "Data review report",
  study_id = "CHUBXYYYY/NN",
  study_name = "The Study Name",
  study_abbreviation = "TSN",
  investigator = "Investigator name",
  methodologist = "Jean Dupont",
  biostatistician = "George Frais",
  datamanager = "Peter Parker",
  methodologist_mail = NULL,
  biostatistician_mail = NULL,
  datamanager_mail = NULL,
  language = "fr"
)
}
\arguments{
\item{folder_path}{The folder where this should be created}

\item{output_folder}{The folder where the html will be recorded.}

\item{name}{The name of the files}

\item{structure}{Character string indicating the organizational structure, either "USMR" or "EUCLID". Default is "USMR".}

\item{path_logo}{Character string specifying the path to the logo image. If NULL, a default logo is used.}

\item{confidential}{Logical value indicating whether the report should be marked as confidential. Default is FALSE.}

\item{report_type}{Character string specifying the type of report. Default is "Data review report".}

\item{study_id}{Character string representing the study identifier. Default is "CHUBXYYYY/NN".}

\item{study_name}{Character string specifying the name of the study. Default is "The Study Name".}

\item{study_abbreviation}{Character string providing the abbreviation of the study. Default is "TSN".}

\item{investigator}{Character string representing the investigator's name. Default is "Investigator name".}

\item{methodologist}{Character string specifying the methodologist's name. Default is "Jean Dupont".}

\item{biostatistician}{Character string specifying the biostatistician's name. Default is "George Frais".}

\item{datamanager}{Character string specifying the data manager's name. Default is "Peter Parker".}

\item{methodologist_mail}{Character string specifying the methodologist's email. If NULL, it is generated automatically.}

\item{biostatistician_mail}{Character string specifying the biostatistician's email. If NULL, it is generated automatically.}

\item{datamanager_mail}{Character string specifying the data manager's email. If NULL, it is generated automatically.}

\item{language}{Character string indicating the language of the report, either "fr" (French) or "en" (English). Default is "fr".}
}
\value{
None. The function writes an HTML report to the specified file path.
}
\description{
This function creates and writes a qmd file with css and html to report statistical analysis.
}
