% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztnbinom2.R
\name{ztnbinom2}
\alias{ztnbinom2}
\alias{dztnbinom2}
\alias{pztnbinom2}
\alias{rztnbinom2}
\title{Reparameterised zero-truncated negative binomial distribution}
\usage{
dztnbinom2(x, mu, size, log = FALSE)

pztnbinom2(q, mu, size, lower.tail = TRUE, log.p = FALSE)

rztnbinom2(n, mu, size)
}
\arguments{
\item{x, q}{integer vector of counts}

\item{mu}{mean parameter, must be positive}

\item{size}{size/dispersion parameter, must be positive}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dztnbinom2} gives the probability mass function, \code{pztnbinom2} gives the distribution function, and \code{rztnbinom2} generates random deviates.
}
\description{
Probability mass function, distribution function, quantile function, and random generation for
the zero-truncated negative binomial distribution reparameterised in terms of mean and size.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.

By definition, this distribution only has support on the positive integers (1, 2, ...).
Any zero-truncated distribution is defined as
\deqn{P(X=x | X>0) = P(X=x) / (1 - P(X=0)),}
where \eqn{P(X=x)} is the probability mass function of the corresponding untruncated distribution.
}
\examples{
set.seed(123)
x <- rztnbinom2(1, mu = 2, size = 1)
d <- dztnbinom2(x, mu = 2, size = 1)
p <- pztnbinom2(x, mu = 2, size = 1)
}
