% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldnorm.R
\name{foldnorm}
\alias{foldnorm}
\alias{dfoldnorm}
\alias{pfoldnorm}
\alias{rfoldnorm}
\title{Folded normal distribution}
\usage{
dfoldnorm(x, mu = 0, sigma = 1, log = FALSE)

pfoldnorm(q, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rfoldnorm(n, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter}

\item{sigma}{scale parameter, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return}

\item{p}{vector of probabilities}
}
\value{
\code{dfoldnorm} gives the density, \code{pfoldnorm} gives the distribution function, and \code{rfoldnorm} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the folded normal distribution.
}
\details{
This implementation of \code{dfoldnorm} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rfoldnorm(1, 1, 2)
d <- dfoldnorm(x, 1, 2)
p <- pfoldnorm(x, 1, 2)
}
