% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirmult.R
\name{dirmult}
\alias{dirmult}
\alias{ddirmult}
\alias{rdirmult}
\title{Dirichlet-multinomial distribution}
\usage{
ddirmult(x, size, alpha, log = FALSE)

rdirmult(n, size, alpha)
}
\arguments{
\item{x}{vector or matrix of non-negative counts, where rows are observations and columns are categories.}

\item{size}{vector of total counts for each observation. Needs to match the row sums of \code{x}.}

\item{alpha}{vector or matrix of positive shape parameters}

\item{log}{logical; if \code{TRUE}, densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{n}{number of random values to return.}
}
\value{
\code{ddirmult} gives the density and \code{rdirmult} generates random samples.
}
\description{
Density and and random generation for the Dirichlet-multinomial distribution.
}
\details{
This implementation of \code{ddirmult} allows for automatic differentiation with \code{RTMB}.
}
\examples{
# single alpha
alpha <- c(1,2,3)
size <- 10
x <- rdirmult(1, size, alpha)
d <- ddirmult(x, size, alpha)
# vectorised over alpha and size
alpha <- rbind(alpha, 2*alpha)
size <- c(size, 3*size)
x <- rdirmult(2, size, alpha)
}
