% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_logLik.R
\name{tidy.logLik}
\alias{tidy.logLik}
\title{Creates a data.frame for a log-likelihood object}
\usage{
\method{tidy}{logLik}(x, ...)
}
\arguments{
\item{x}{x A log-likelihood object, typically returned by \link{logLik}.}

\item{...}{Additional arguments (not used)}
}
\value{
A \link{data.frame} with columns:
\describe{
\item{term}{The term name}
\item{estimate}{The log-likelihood value}
\item{df}{The degrees of freedom}
}
}
\description{
Creates a data.frame for a log-likelihood object
}
\examples{
fit <- lm(mpg ~ wt, data = mtcars)
logLik_fit <- logLik(fit)
tidy(logLik_fit)
}
\seealso{
\code{\link[stats]{logLik}}
}
\author{
Davood Tofighi \email{dtofighi@gmail.com}
}
