% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_plots.R
\name{plot.flFitSpline}
\alias{plot.flFitSpline}
\title{Generic plot function for \code{flFitSpline} objects.}
\usage{
\method{plot}{flFitSpline}(
  x,
  add = FALSE,
  raw = TRUE,
  slope = TRUE,
  deriv = TRUE,
  spline = TRUE,
  log.y = FALSE,
  basesize = 16,
  pch = 1,
  colData = 1,
  colSpline = "dodgerblue3",
  cex.point = 2,
  lwd = 0.7,
  y.lim = NULL,
  x.lim = NULL,
  y.lim.deriv = NULL,
  n.ybreaks = 6,
  y.title = NULL,
  x.title = NULL,
  y.title.deriv = NULL,
  plot = TRUE,
  export = FALSE,
  width = 8,
  height = ifelse(deriv == TRUE, 8, 6),
  out.dir = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{flFitSpline}, created with \code{\link{flFitSpline}}.}

\item{add}{(Logical) Shall the fitted spline be added to an existing plot? \code{TRUE} is used internally by \code{\link{plot.flBootSpline}}.}

\item{raw}{(Logical) Display raw growth as circles (\code{TRUE}) or not (\code{FALSE}).}

\item{slope}{(Logical) Show the slope at the maximum slope (\code{TRUE}) or not (\code{FALSE}).}

\item{deriv}{(Logical) Show the derivative (i.e., slope) over time in a secondary plot (\code{TRUE}) or not (\code{FALSE}).}

\item{spline}{(Logical) Only for \code{add = TRUE}: add the current spline to the existing plot (\code{FALSE}).}

\item{log.y}{(Logical) Log-transform the y-axis (\code{TRUE}) or not (\code{FALSE}).}

\item{basesize}{(Numeric) Base font size.}

\item{pch}{(Numeric) Symbol used to plot data points.}

\item{colData}{(Numeric or character) Contour color of the raw data circles.}

\item{colSpline}{(Numeric or character) Spline line colour.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{lwd}{(Numeric) Spline line width.}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on y-axis of the fluorescence curve plot as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis of both fluorescence curve and derivative plots as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{y.lim.deriv}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the y-axis of the derivative plot as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{n.ybreaks}{(Numeric) Number of breaks on the y-axis. The breaks are generated using \code{axisTicks()}. Thus, the final number of breaks can deviate from the user input.}

\item{y.title}{(Character) Optional: Provide a title for the y-axis of the growth curve plot.}

\item{x.title}{(Character) Optional: Provide a title for the x-axis of both growth curve and derivative plots.}

\item{y.title.deriv}{(Character) Optional: Provide a title for the y-axis of the derivative plot.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}). If \code{FALSE}, a ggplot object is returned.}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A plot with the nonparametric fit.
}
\description{
\code{plot.flFitSpline} generates the spline fit plot for a single sample.
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Extract time and normalized fluorescence data for single sample
time <- input$time[4,]
data <- input$norm.fluorescence[4,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- flFitSpline(time = time,
                       fl_data = data,
                       ID = "TestFit",
                       control = fl.control(fit.opt = "s", x_type = "time"))

plot(TestFit)
}
