% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.profilePredict.R
\name{plot.profilePredict}
\alias{plot.profilePredict}
\title{Plotting Predicted Run-Off Diagonal}
\usage{
\method{plot}{profilePredict}(
  x,
  xlab = "Development period",
  ylab = "Cumulative claims",
  main = "",
  trueProfiles = NULL,
  default.legend = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of the class \code{profileLadder} which is the output form
\code{parallelReserve()} or \code{mcReserve()}}

\item{xlab}{label for the x axis}

\item{ylab}{label for the y axis}

\item{main}{title of the plot}

\item{trueProfiles}{optional parameter (set to \code{NULL} by default) providing
true profiles, if available. In such case, the predicted diagonal is also
graphically compared with the true profile developments. The parameter can be
a vector (of the same length as the number of rows in the run-off triangle)
providing true values of the next running diagonal or it can be a matrix (an
object of the class \code{matrix} or \code{triangle}) with the dimensions \code{n x m}
(where \code{n x n} is the dimension of the run-off triangle and \code{m > n}).}

\item{default.legend}{logical to indicate whether a default plot legend
(utilizing the information from the R class \code{profileLadder}) should be
provided  (DEFAULT)}

\item{...}{other graphical parameters to plot}
}
\value{
A graph with the observed functional development profiles from the
input run-off triangle and the predicted new running diagonal (1-step-ahead
prediction)
}
\description{
The function provides a graphical visualization of a 1-step-ahead prediction
for the functional (development) profiles (so called new running diagonal) obtained
by the S3 method \code{predict()} applied to the output of the PARALLAX, REACT,
or MACRAME algorithm---the R functions \code{parallelReserve()} or \code{mcReserve()}.
}
\examples{
## new running diagonal provided by PARALLAX
print(CameronMutual)
plot(predict(parallelReserve(CameronMutual)))

## new running diagonal with the true profiles
print(covid19CZ)
plot(predict(mcReserve(covid19CZ[,4:7])), trueProfiles = covid19CZ)

}
\seealso{
[\code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}, \code{\link[=predict.profileLadder]{predict.profileLadder()}}
}
