% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_bridgeability_plot.R
\name{olink_bridgeability_plot}
\alias{olink_bridgeability_plot}
\title{Plots for each bridgeable assays between two products.}
\usage{
olink_bridgeability_plot(
  data,
  olink_id = NULL,
  median_counts_threshold = 150L,
  min_count = 10L
)
}
\arguments{
\item{data}{A tibble containing the cross-product bridge normalized dataset
generated by \code{\link{olink_normalization}}.}

\item{olink_id}{Character vector of Olink assay identifiers \var{OlinkID} for
which bridgeability plots will be created. If null, plots for all assays in
\var{data} will be created. (default = NULL)}

\item{median_counts_threshold}{Threshold indicating the minimum median counts
for each product (default = 150).}

\item{min_count}{Threshold indicating the minimum number of counts per
data point (default = 10). Data below \var{min_count} are excluded.}
}
\value{
An object of class "ggplot" containing 4 plots for each assay.
}
\description{
Plots for each bridgeable assays between two products.
}
\examples{
\donttest{
npx_ht <- OlinkAnalyze:::data_ht_small |>
  dplyr::filter(
    .data[["SampleType"]] == "SAMPLE"
  )

npx_3072 <- OlinkAnalyze:::data_3k_small |>
  dplyr::filter(
    .data[["SampleType"]] == "SAMPLE"
  )

overlapping_samples <- intersect(
  x = npx_ht$SampleID,
  y = npx_3072$SampleID
)

data_norm <- OlinkAnalyze::olink_normalization(
  df1 = npx_ht,
  df2 = npx_3072,
  overlapping_samples_df1 = overlapping_samples,
  df1_project_nr = "Explore HT",
  df2_project_nr = "Explore 3072",
  reference_project = "Explore HT"
)

data_norm_bridge_p <- OlinkAnalyze::olink_bridgeability_plot(
  data = data_norm,
  olink_id = c("OID40770", "OID40835"),
  median_counts_threshold = 150L,
  min_count = 10L
)
}

}
\author{
Amrita Kar
Klev Diamanti

Generates a combined plot per assay containing a violin and boxplot for IQR
ranges; correlation plot of NPX values; a median count bar plot and KS plots
from the 2 products.
}
