% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{sleep_disorder_df}
\alias{sleep_disorder_df}
\title{Transient Sleep Disorder Polysomnography Scoring Data}
\format{
A data frame with 82 observations and 3 variables:
\describe{
  \item{manual}{Latency to persistent sleep measured using manual scoring (numeric)}
  \item{automated}{Latency to persistent sleep measured using automated scoring (numeric)}
  \item{partial}{Latency to persistent sleep measured using semi-automated (partial) scoring (numeric)}
}
}
\source{
Data taken from the MVT package version 0.3-81
}
\usage{
data(sleep_disorder_df)
}
\description{
This dataset, sleep_disorder_df, is a data frame containing polysomnographic (PSG) measurements from a
clinical study designed to compare automated and semi-automated scoring methods used in the diagnosis of
transient sleep disorders. The study included 82 patients who were administered a sleep-inducing drug
(Zolpidem 10 mg). The primary measure of interest is the latency to persistent sleep (LPS), defined as the
time from lights out to the beginning of 10 consecutive minutes of uninterrupted sleep. LPS was measured
using three different scoring methods: manual, automated, and partial.
}
\details{
The dataset name has been kept as sleep_disorder_df to avoid confusion with other datasets in the R
ecosystem. This naming convention helps distinguish this dataset as part of the NeuroDataSets package
and assists users in identifying its specific characteristics. The suffix df indicates that the dataset is
a data frame. The original content has not been modified in any way.
}
