% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{turtlesOn}
\alias{turtlesOn}
\alias{turtlesOn,worldNLR,agentMatrix,matrix,missing-method}
\alias{turtlesOn,worldNLR,agentMatrix,matrix,character-method}
\title{\code{Turtles} on}
\usage{
turtlesOn(world, turtles, agents, breed, simplify = TRUE)

\S4method{turtlesOn}{worldNLR,agentMatrix,matrix,missing}(world, turtles, agents, simplify)

\S4method{turtlesOn}{worldNLR,agentMatrix,matrix,character}(world, turtles, agents, breed, simplify = TRUE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{breed}{Characters. Vector of \code{breed} names for the selected \code{turtles}.
If missing, there is no distinction based upon \code{breed}.}

\item{simplify}{Logical. If \code{simplify = TRUE}, all \code{turtles} on the same
\code{patches} as any \code{agents} are returned; if \code{simplify = FALSE},
the \code{turtles} are evaluated for each \code{agents}'s \code{patches}
individually.}
}
\value{
\code{AgentMatrix} representing any individuals from \code{turtles} of
any of the given \code{breed}, if specified,
located on the same \code{patches} as any of the \code{agents}, if \code{simplify = TRUE}, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Matrix (`ncol` = 2) with the first column `whoTurtles` and the second column
    `id` showing which `turtles` are on the same
    `patches` as which `agents` represented by `id`, if `simplify = FALSE`.
    `id` represents and follows the order of the `agents`. `id` does not represent
    the `who` numbers
    of the `agents` if `agents` are `turtles`.
}\if{html}{\out{</div>}}
}
\description{
Report the individuals among \code{turtles} that are on the same \code{patches} as
the \code{agents}.
}
\details{
The \code{agents} must be located inside the
\code{world}'s extent.
}
\examples{
w1 <- createWorld(
  minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9,
  data = runif(100)
)
t1 <- createTurtles(n = 500, coords = randomXYcor(w1, n = 500))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

t2 <- turtlesOn(world = w1, turtles = t1, agents = patch(w1, 2, 2))

}
\references{
Wilensky, U. 1999. NetLogo. https://www.netlogo.org.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#turtles-on}
}
\author{
Sarah Bauduin
}
