% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{GeneralMLEInputs}
\alias{GeneralMLEInputs}
\title{Gathers the general inputs for model estimation}
\usage{
GeneralMLEInputs(
  Yields,
  RiskFactors,
  FactorLabels,
  mat,
  DataFrequency,
  Label_Multi_Models,
  Economies,
  ModelType,
  UnitYields
)
}
\arguments{
\item{Yields}{matrix (CJ x T) or a list containing those matrices, where C is the number of countries,
J - the number of maturities and T - time series length \cr}

\item{RiskFactors}{time series of risk factors (F x T). Could be stored in a list depending on the model}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{mat}{vector of maturities (in years) used in the estimation}

\item{DataFrequency}{single element character-based vector. Available options are: "Daily All Days", \cr
"Daily Business Days", "Weekly", "Monthly",  "Quarterly", "Annually"}

\item{Label_Multi_Models}{string-vector containing the names of the multicountry setups}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{string-vector containing the label of the model to be estimated}
}
\description{
Gathers the general inputs for model estimation
}
\keyword{internal}
