#' Example serial interval data
#'
#' A data frame containing serial interval information for transmission pairs.
#'
#' @docType data
#' @usage data(DONNEE_with_serial_interval)
#' @format A data frame with columns:
#' \describe{
#'   \item{ID}{Integer. Unique identifier.}
#'   \item{x.lb}{Date. Lower bound of infector symptom onset (YYYY-MM-DD).}
#'   \item{x.ub}{Date. Upper bound of infector symptom onset (YYYY-MM-DD).}
#'   \item{y}{Date. Infectee symptom onset (YYYY-MM-DD).}
#'   \item{serial_interval}{Integer. Serial interval in days.}
#' }
#' @source Simulated or real data for demonstration.
"DONNEE_with_serial_interval"

#' Example transmission pair data with mean serial interval
#'
#' A data frame of infector-infectee pairs with demographic and serial interval information.
#'
#' @docType data
#' @usage data(TableS2_serial_interval_mean_)
#' @format A data frame with columns:
#' \describe{
#'   \item{infector_id}{Character. Infector ID.}
#'   \item{infector_age}{Numeric. Age of infector.}
#'   \item{infector_sex}{Character. Sex of infector.}
#'   \item{infector_onsetDate}{Date. Infector symptom onset.}
#'   \item{infector_labConfirmDate}{Date. Infector lab confirmation.}
#'   \item{infectee_id}{Character. Infectee ID.}
#'   \item{infectee_age}{Numeric. Age of infectee.}
#'   \item{infectee_sex}{Character. Sex of infectee.}
#'   \item{infectee_onsetDate}{Date. Infectee symptom onset.}
#'   \item{infectee_labConfirmDate}{Date. Infectee lab confirmation.}
#'   \item{serial_interval_mean_based}{Numeric. Mean-based serial interval.}
#' }
#' @source Simulated or real data for demonstration.
"TableS2_serial_interval_mean_"
