% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sketch_Functions.R
\name{Choose}
\alias{Choose}
\alias{ChooseEffort}
\alias{ChooseM}
\alias{ChooseSelect}
\title{Manually map parameters for the historical period of operating model}
\usage{
ChooseEffort(Fleet, Years = NULL)

ChooseM(OM, type = c("age", "length"), x = NULL, y = NULL)

ChooseSelect(Fleet, Stock, FstYr = NULL, SelYears = NULL)
}
\arguments{
\item{Fleet}{A fleet object.}

\item{Years}{An optional vector of years. Should be nyears long.}

\item{OM}{An object of class 'OM'}

\item{type}{A character string - is M to be mapped by 'age' or 'length'?}

\item{x}{Optional vector for x-axis}

\item{y}{Optional vector for y-axis}

\item{Stock}{Optional Stock object. If provided, average length-at-maturity
is included on plot for reference.}

\item{FstYr}{Optional value for first historical year. If empty, user must
specify the year in console.}

\item{SelYears}{Optional vector of values for each year where selectivity
pattern changed. If empty, user must specify the years in console (comma
separated).}
}
\value{
\code{ChooseEffort} and \code{ChooseSelect} return a Fleet object while
\code{ChooseM} returns an OM object.
}
\description{
Interactive plots to specify trends and variability in
fishing effort, fleet selectivity, and natural mortality for the
operating model.
}
\details{
\tabular{ll}{
\code{ChooseEffort} \tab Interactive plot which allows users to specify the
relative trajectory and variability in the historical fishing effort and
populates Fleet object. \cr
\code{ChooseM} \tab Interactive plot which allows users to specify M by age
or size class \cr
\code{ChooseSelect} \tab Input the first historical year, and all years where
selectivity pattern
changed (separated by comma).  Interactive plot which allows users to
specify a range for the length at 5\\% and full selection (LFS), as well as
selectivity at maximum length for each year.  Produces a simple plot which
shows the range in selectivity pattern for each break-point year.
Selectivity-at-length is fixed in between break-point years.  Note that this
function replaces 'nyears' in the Fleet object with the value defined here
(FstYr:current year). \cr
}
}
\author{
A. Hordyk
}
