% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_full_ss.R
\name{eta_full_ss}
\alias{eta_full_ss}
\alias{eta.full.SS}
\title{\eqn{\eta^2} for ANOVA from \eqn{F} and Sum of Squares}
\usage{
eta_full_ss(dfm, dfe, ssm, sst, f_value, a = 0.05, Fvalue)

eta.full.SS(dfm, dfe, ssm, sst, Fvalue, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{ssm}{sum of squares for the model/IV/between}

\item{sst}{sum of squares total}

\item{f_value}{F statistic}

\item{a}{significance level}

\item{Fvalue}{Backward-compatible argument for the F statistic
(deprecated; use `f_value` instead). If supplied, it overrides
`f_value`. Included for users of the legacy `eta.full.SS()`.}
}
\value{
Provides the effect size (\eqn{\eta^2}) with associated
confidence intervals and relevant statistics.

\describe{
  \item{eta}{\eqn{\eta^2} effect size}
  \item{etalow}{lower level confidence interval of \eqn{\eta^2}}
  \item{etahigh}{upper level confidence interval of \eqn{\eta^2}}
  \item{dfm}{degrees of freedom for the model/IV/between}
  \item{dfe}{degrees of freedom for the error/residual/within}
  \item{F}{\eqn{F}-statistic}
  \item{p}{p-value}
  \item{estimate}{the \eqn{\eta^2} statistic and confidence interval
in APA style for markdown printing}
  \item{statistic}{the \eqn{F}-statistic in APA style for markdown printing}
}
}
\description{
This function displays \eqn{\eta^2} from ANOVA analyses
and its non-central confidence interval based on the \eqn{F} distribution.
This formula works for one way and multi way designs with careful
focus on the sum of squares total.
}
\details{
Eta squared is calculated by dividing the sum of squares for the model
by the sum of squares total.

\deqn{\eta^2 = \frac{SS_M}{SS_T}}

**Note on function and output names:** This effect size is now implemented
with the snake_case function name `eta_full_ss()` to follow modern R style
guidelines. The original dotted version `eta.full.SS()` is still available
as a wrapper for backward compatibility, and both functions return the same
list. The returned object includes both the original element names
(e.g., `eta`, `etalow`, `etahigh`, `dfm`, `dfe`, `F`, `p`, `estimate`,
`statistic`) and newer snake_case aliases (e.g., `eta_value`,
`eta_lower_limit`, `eta_upper_limit`, `df_model`, `df_error`, `f_value`,
`p_value`). New code should prefer `eta_full_ss()` and the snake_case
output names, but existing code using the older names will continue to work.

\href{https://www.aggieerin.com/shiny-server/tests/etass.html}{Learn more on our example page.}
}
\examples{

# The following example is derived from the "bn1_data"
# dataset, included in the MOTE library.

# A health psychologist recorded the number of close inter-personal
# attachments of 45-year-olds who were in excellent, fair, or poor
# health. People in the Excellent Health group had 4, 3, 2, and 3
# close attachments; people in the Fair Health group had 3, 5,
# and 8 close attachments; and people in the Poor Health group
# had 3, 1, 0, and 2 close attachments.

anova_model <- lm(formula = friends ~ group, data = bn1_data)
summary.aov(anova_model)

eta_full_ss(dfm = 2, dfe = 8, ssm = 25.24,
            sst = (25.24 + 19.67), f_value = 5.134, a = .05)

# Backwards-compatible dotted name (deprecated)
eta.full.SS(dfm = 2, dfe = 8, ssm = 25.24,
            sst = (25.24 + 19.67), Fvalue = 5.134, a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{eta}
\keyword{size}
