% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_to_r.R
\name{d_to_r}
\alias{d_to_r}
\alias{d.to.r}
\title{r and Coefficient of Determination (R2) from d}
\usage{
d_to_r(d, n1, n2, a = 0.05)

d.to.r(d, n1, n2, a = 0.05)
}
\arguments{
\item{d}{Effect size statistic.}

\item{n1}{Sample size for group one.}

\item{n2}{Sample size for group two.}

\item{a}{Significance level.}
}
\value{
Provides the effect size (correlation coefficient) with associated
confidence intervals, the t-statistic, F-statistic, and other estimates
appropriate for d to r translation. Note this CI is not based on the
traditional r-to-z transformation but rather non-central F using the
ci.R function from MBESS.

\describe{
  \item{r}{Correlation coefficient.}
  \item{rlow}{Lower level confidence interval for r.}
  \item{rhigh}{Upper level confidence interval for r.}
  \item{R2}{Coefficient of determination.}
  \item{R2low}{Lower level confidence interval of R2.}
  \item{R2high}{Upper level confidence interval of R2.}
  \item{se}{Standard error.}
  \item{n}{Sample size.}
  \item{dfm}{Degrees of freedom of mean.}
  \item{dfe}{Degrees of freedom error.}
  \item{t}{t-statistic.}
  \item{F}{F-statistic.}
  \item{p}{p-value.}
  \item{estimate}{The r statistic and confidence interval in
APA style for markdown printing.}
  \item{estimateR2}{The R\eqn{^2} statistic and confidence
interval in APA style for markdown printing.}
  \item{statistic}{The t-statistic in APA style for markdown printing.}
}
}
\description{
**Note on function and output names:** This effect size translation is now
implemented with the snake_case function name `d_to_r()` to follow modern
R style guidelines. The original dotted version `d.to.r()` is still
available as a wrapper for backward compatibility, and both functions
return the same list. The returned object includes both the original
element names (e.g., `r`, `rlow`, `rhigh`, `R2`, `R2low`, `R2high`, `se`,
`n`, `dfm`, `dfe`, `t`, `F`, `p`, `estimate`, `estimateR2`, `statistic`)
and newer snake_case aliases (e.g., `r_lower_limit`, `r_upper_limit`,
`r2_value`, `r2_lower_limit`, `r2_upper_limit`, `se_value`,
`sample_size`, `degrees_freedom_model`, `degrees_freedom_error`,
`t_value`, `f_value`, `p_value`, `estimate_r`, `estimate_r2`). New code
should prefer `d_to_r()` and the snake_case output names, but existing
code using the older names will continue to work.
}
\details{
Calculates r from d and then translates r to r2 to calculate
the non-central confidence interval for r2 using the F distribution.

The correlation coefficient (\eqn{r}) is calculated by dividing Cohen's d
by the square root of the total sample size squared, divided
by the product of the sample sizes of group one and group two.

\deqn{r = \frac{d}{\sqrt{d^2 + \frac{(n_1 + n_2)^2}{n_1 n_2}}}}

\href{https://www.aggieerin.com/shiny-server/tests/dtor.html}{Learn more on our example page.}
}
\examples{

# The following example is derived from the "indt_data"
# dataset, included in the MOTE library.

# A forensic psychologist conducted a study to examine whether
# being hypnotized during recall affects how well a witness
# can remember facts about an event. Eight participants
# watched a short film of a mock robbery, after which
# each participant was questioned about what he or she had
# seen. The four participants in the experimental group
# were questioned while they were hypnotized. The four
# participants in the control group received the same
# questioning without hypnosis.

# Contrary to the hypothesized result, the group that underwent
# hypnosis were significantly less accurate while reporting
# facts than the control group with a large effect size, t(6) = -2.66,
# p = .038, d_s = -1.88.

     d_to_r(d = -1.88, n1 = 4, n2 = 4, a = .05)
}
\keyword{correlation}
\keyword{effect}
\keyword{size}
