% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\alias{compute_coverage}
\alias{plot_coverage}
\title{Coverage probability}
\usage{
compute_coverage(
  post_samples,
  truth,
  CI = seq(0, 1, 0.05),
  type = c("eti", "hdi")
)

plot_coverage(
  post_samples,
  truth,
  CI = seq(0, 1, 0.05),
  type = c("eti", "hdi")
)
}
\arguments{
\item{post_samples}{Matrix of posterior samples. Rows represent a sample and columns represent variables.}

\item{truth}{Vector of true parameter values (should be the same length as the number of columns in \code{post_samples}).}

\item{CI}{Vector of confidence levels.}

\item{type}{Type of confidence intervals: either "eti" (equal-tailed intervals) or "hdi" (highest density intervals).}
}
\value{
\code{compute_coverage} returns a Dataframe containing coverage (and 95\% uncertainty interval for the coverage) for different confidence level (nominal coverage).
\code{plot_coverage} returns a ggplot of the coverage as the function of the nominal coverage with 95\% uncertainty interval.
}
\description{
Compute and plot coverage of CI for different confidence level.
Useful for fake data check.
}
\examples{
N <- 100
N_post <- 1e3
truth <- rep(0, N)
post_samples <- sapply(rnorm(N, 0, 1), function(x) {
  rnorm(N_post, x, 1)
})

compute_coverage(post_samples, truth)
plot_coverage(post_samples, truth)
}
