% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cbbPalette}
\alias{cbbPalette}
\title{A colour blind friendly palette (with black)}
\format{
An object of class \code{character} of length 8.
}
\source{
\href{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)}{Cookbook for R}
}
\usage{
cbbPalette
}
\description{
Shortcut for \code{c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7")}.
}
\examples{
library(ggplot2)
library(dplyr)
df <- data.frame(palette = HuraultMisc::cbbPalette) \%>\%
  mutate(palette = factor(palette, levels = palette))

ggplot(data = df, aes(x = palette, fill = palette, y = 0)) +
  geom_tile() +
  scale_fill_manual(values = levels(df$palette)) +
  coord_cartesian(expand = FALSE) +
  labs(x = "", y = "") +
  theme_classic(base_size = 15) +
  theme(legend.position = "none")

}
\keyword{datasets}
