% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WritePmsf}
\alias{WritePmsf}
\title{Write a 'pmsf.txt' file}
\usage{
WritePmsf(x, filename)
}
\arguments{
\item{x}{The object to be written, an \code{integer} vector containing SUBIDs.}

\item{filename}{A character string naming a file to write to. Windows users: Note that
Paths are separated by '/', not '\\'.}
}
\value{
No return value, called for export to text files.
}
\description{
This is a small convenience function to export a 'partial model setup file' from R.
}
\details{
Pmsf files are represented as integer vectors in R. The total number of subcatchments in the file are added as first value on export.
pmsf.txt files need to be ordered as downstream sequence.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
WritePmsf(x = te$SUBID[te$SUBID \%in\% AllUpstreamSubids(3564, te)], filename = tempfile())

}
\seealso{
\code{\link{AllUpstreamSubids}}, which extracts upstream SUBIDs from a GeoData dataframe.
}
