% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WritePar}
\alias{WritePar}
\title{Write a 'par.txt' File}
\usage{
WritePar(x, filename, digits = 10, nsmall = 1)
}
\arguments{
\item{x}{The object to be written, a list with named vector elements, as an object returned from \code{\link{ReadPar}}.}

\item{filename}{A character string naming a file to write to. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{digits}{Integer, number of significant digits to export. See \code{\link{format}}.}

\item{nsmall}{Integer, number of significant decimals to export. See \code{\link{format}}.}
}
\value{
No return value, called for export to text files.
}
\description{
\code{WritePar} prints its required argument \code{x} to a file.
}
\details{
\code{WritePar} writes a 'par.txt' file, typically originating from an imported and modified 'par.txt'.
}
\examples{
te <- ReadPar(filename = system.file("demo_model", "par.txt", package = "HYPEtools"))
# Note that par files lose all comment rows on import
WritePar(x = te, filename = tempfile())


}
\seealso{
\code{\link{ReadPar}} with a description of the expected content of \code{x}.
}
