% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_OutletIds.R
\name{OutletIds}
\alias{OutletIds}
\title{Find Outlet IDs}
\usage{
OutletIds(gd)
}
\arguments{
\item{gd}{Data frame with two columns \code{subid} and \code{maindown} (not case-sensitive).
Typically a 'GeoData.txt' file imported using \code{\link{ReadGeoData}}.}
}
\value{
\code{OutletIds} returns a vector of outlet IDs.
}
\description{
Function to find the identifier(s) used to signify model domain outlets, i.e. the "downstream" ID of outlet catchments, in a GeoData file.
This is typically just one number, often e.g. '0' or '-9999', but can be one or several IDs if the GeoData file originates from a HYPE sub-model
set-up, e.g. created with the 'SelectAro' program. Use \code{\link{OutletSubids}} to find the actual SUBID values of the outlet catchments.
}
\details{
\code{OutletIds} finds the unique outlet IDs of a GeoData file. The outlet ID of a typical model
is a single placeholder number, often e.g. '0' or '-9999', but there can be several outlet IDs, e.g. one or
several SUBIDs if the GeoData file originates from a HYPE sub-model set-up, created
with the 'SelectAro' tool.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
OutletIds(gd = te)

}
\seealso{
\code{\link{AllDownstreamSubids}}, \code{\link{OutletSubids}}
}
