% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_match_search.R
\name{resultsBinaryMatchSearch}
\alias{resultsBinaryMatchSearch}
\title{Binary Pair Match Search}
\usage{
resultsBinaryMatchSearch(obj, form = "one_zero")
}
\arguments{
\item{obj}{The \code{pairwise_matching_experimental_design_search} object that is currently running the search}

\item{form}{Which form should the assignments be in? The default is \code{one_zero} for 1/0's or \code{pos_one_min_one} for +1/-1's.}
}
\description{
Returns the results (thus far) of the binary pair match design search
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(16), nrow = 8)
bms = computeBinaryMatchStructure(X)
bm = initBinaryMatchExperimentalDesignSearchObject(
  bms,
  max_designs = 4,
  num_cores = 1,
  start = TRUE,
  wait = TRUE,
  seed = 1,
  verbose = FALSE
)
res = resultsBinaryMatchSearch(bm, form = "one_zero")
dim(res)
}
}
\author{
Adam Kapelner
}
