#' Theoretical CDF of RIG for a given number of vertices.
#'
#' Computes the theoretical CDF for RIG with for a given number of vertices.
#'
#' @param m Number of observations.
#' @return A vector representing the theoretical CDF of RIG with m/2 vertices.
#' @examples
#' cdf.rig(1000) 
#' @export
cdf.rig <- function(m) {
  nv <- m %/% 2
  xx <- seq(0, 0.999, length.out = nv)
  cdf_t <- rep(0, length(xx))
  for (k in xx) {
    if (k < 0.5) {
      cdf_t[which(xx == k)] <- 1 - (1 - k) * (pi / 2 - 2 * acos(1 / sqrt(2 - 2 * k))) - sqrt(1 - 2 * k)
    } else {
      cdf_t[which(xx == k)] <- 1 - (1 - k) * pi / 2
    }
  }
  return(cdf_t)
}
