% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_value.R
\encoding{UTF-8}
\name{expected_value.maxlogL}
\alias{expected_value.maxlogL}
\title{Expected value of a \code{maxlogLreg} model.}
\usage{
expected_value.maxlogL(object, g = identity, routine, ...)
}
\arguments{
\item{object}{an object of \code{\link{maxlogL}} class obtained by fitting a
model with \code{\link{maxlogLreg}}.}

\item{g}{a given function \eqn{g(x)}.}

\item{routine}{a character specifying the integration routine.
\code{integrate} and \code{gauss_quad} are available for
continuous distributions, and \code{summate} for discrete ones.
Custom routines can be defined but they must be compatible
with the \code{\link{integration}} API.}

\item{...}{further arguments for the integration routine.}
}
\value{
the expected value of the fitted model corresponding to the
distribution specified in the \code{y_dist} argument of
\code{\link{maxlogLreg}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes a \code{maxlogL} model and computes the expected value
using the estimated parameters. The expected value is computed using the
following expression

\deqn{\hat{E[g(X)]} = \int_{-\infty}^{\infty} x f(x|\hat{\theta}) dx,}

where \eqn{f(x|\hat{\theta})} is a probability density function using the
estimated parameters.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example 1: mean value of a estimated model.
n <- 100
x <- runif(n = n, -5, 6)
y <- rnorm(n = n, mean = -2 + 3 * x, sd = 0.3)
norm_data <- data.frame(y = y, x = x)

formulas <- list(sd.fo = ~ 1, mean.fo = ~ x)
support <- list(interval = c(-Inf, Inf), type = "continuous")

norm_mod_maxlogL <- maxlogLreg(
  formulas, y_dist = y ~ dnorm,
  support = support,
  data = norm_data,
  link = list(over = "sd", fun = "log_link")
)

# Actual y values
y <- norm_mod_maxlogL$outputs$response

# Expected value
Ey <- expected_value.maxlogL(
  object = norm_mod_maxlogL,
  routine = "monte-carlo"
)

# Compare
plot(y, Ey)


#----------------------------------------------------------------------------

}
\seealso{
Other maxlogL: 
\code{\link{cum_hazard.maxlogL}()},
\code{\link{maxlogL}()},
\code{\link{maxlogLreg}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{maxlogL}
