% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_geographic_map.R
\name{ec_geographic_map}
\alias{ec_geographic_map}
\title{Map view of occurrence data points}
\usage{
ec_geographic_map(
  data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)
}
\arguments{
\item{data}{Data table}

\item{latitude}{default set to "decimalLatitude"}

\item{longitude}{default set to "decimalLongitude"}
}
\value{
A map view shows occurrence records.
}
\description{
Map view of occurrence data points
}
\examples{
data <- data.frame(
  scientificName = "Mexacanthina lugubris",
  decimalLongitude = c(-117, -117.8, -116.9),
  decimalLatitude = c(32.9, 33.5, 31.9),
  temperature_mean = c(12, 13, 14),
  temperature_min = c(9, 6, 10),
  temperature_max = c(14, 16, 18)
)
ec_geographic_map(data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)

}
