% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistanceFromRank.R
\name{DistanceFromRank}
\alias{DistanceFromRank}
\title{\code{DistanceFromRank}:
Creates a 3-dimensional distance array from the results 
of a ranking task.}
\usage{
DistanceFromRank(X)
}
\arguments{
\item{X}{gives the results of a ranking task 
(see example below) as an
objects (rows) by assessors (columns) matrix.}
}
\value{
\code{DistanceFromRank} returns an
 \eqn{I\times I \times K}{I*I*K}
array of distance.
}
\description{
\code{DistanceFromRank}:  
Takes the results from a (plain) ranking task 
where \eqn{K} assessors rank (with possible ties)
\eqn{I} observations on 
one dimension and transform it into a brick of data
to be used by \code{distatis}.
}
\details{
\code{DistanceFromRank} creates an 
 \eqn{I \times I \times K}{I*I*K} 
array of distance 
in which each of the \eqn{K} "slices"
stores the (squared Euclidean ranking) 
distance matrix of the \eqn{k}th assessor.  
In one of
these distance matrices, the distance 
between two objects is computed
from he Pythagorean theorem. 
The ouput ot the function \code{DistanceFromRank} 
is used as input for the
function \code{\link{distatis}}.

The input should have assessors as columns and observations 
as rows (see
example below).
}
\examples{
# Use the data set WinesRankingRawData stored in an excel file.
path2file <- system.file("extdata",
           "WinesRankingRawData.xlsx", package = 'DistatisR')
ranking6Wines <- read.df.excel(path = path2file, sheet = 'Ranking')
aCubeOfDistance <- DistanceFromRank(ranking6Wines$df.data)

}
\seealso{
\code{\link{distatis}} \code{\link{DistanceFromSort}}
}
\author{
Herve Abdi
}
