% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_neural.R
\name{neuralnet_complier_mod}
\alias{neuralnet_complier_mod}
\title{Train compliance model using neural networks}
\usage{
neuralnet_complier_mod(
  complier.formula,
  exp.data,
  treat.var,
  algorithm = "rprop+",
  hidden.layer = c(4, 2),
  act.fct = "logistic",
  ID = NULL,
  stepmax = 1e+08
)
}
\arguments{
\item{complier.formula}{formula for complier variable as outcome and
covariates (c ~ x)}

\item{exp.data}{\code{data.frame} for experimental data.}

\item{treat.var}{string for treatment variable.}

\item{algorithm}{string for algorithm for training neural networks.
Default set to the Resilient back propagation with weight backtracking
(rprop+). Other algorithms include backprop', rprop-', 'sag', or 'slr'
(see \code{neuralnet} package).}

\item{hidden.layer}{vector for specifying hidden layers and number of neurons.}

\item{act.fct}{"logistic" or "tanh activation function.}

\item{ID}{string for identifier variable}

\item{stepmax}{maximum number of steps.}
}
\value{
trained complier model object
}
\description{
Train model using group exposed to treatment with compliance as binary
outcome variable and covariates.
}
