% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsHasSession}
\alias{dsHasSession}
\title{Check remote R session exists}
\usage{
dsHasSession(conn)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}
}
\value{
A logical indicating if a remote R session exists accessible through this connection.
}
\description{
Check if a remote R session exists (not necessarily running and ready to accept 
R commands submissions).
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsHasSession(con)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRestoreWorkspace}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()},
\code{\link{dsSession}()}
}
\concept{DSConnection generics}
