% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{find_base_coordinates_raster}
\alias{find_base_coordinates_raster}
\title{Find stem base position using a density raster approach}
\usage{
find_base_coordinates_raster(
  las,
  res = 0.1,
  zmin = 0.5,
  zmax = 2,
  q = 0.975,
  eps = 0.2
)
}
\arguments{
\item{las}{an element of lidR::LAS class}

\item{res}{raster resolution}

\item{zmin}{lower search boundary}

\item{zmax}{upper search boundary}

\item{q}{quantile of raster density to assign a tree region}

\item{eps}{search radius to merge base points}
}
\value{
data.frame with X, Y, Z and TreeID for stem base positions
}
\description{
Find stem base position using a density raster approach
}
\examples{
# read example data
file = system.file("extdata", "beech.las", package="CspStandSegmentation")
tls = lidR::readTLSLAS(file)

# Find tree positions
map <- CspStandSegmentation::find_base_coordinates_raster(tls)
}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
