% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossExpression.R
\name{tissue_expression_plot}
\alias{tissue_expression_plot}
\title{Plots gene expression and cross-expression on tissue by coloring cells.}
\usage{
tissue_expression_plot(
  data,
  locations,
  gene1,
  gene2,
  cross_expression = TRUE,
  neighbor = 1,
  point_size = 0,
  scale_bar = 0
)
}
\arguments{
\item{data}{A cells by genes expression matrix.}

\item{locations}{A cells by coordinates (x-y or higher dimensions) matrix.}

\item{gene1}{Name of gene 1.}

\item{gene2}{Name of gene 2.}

\item{cross_expression}{If TRUE, only cross-expressing cell pairs are shown.}

\item{neighbor}{The nearest neighbor (for cross-expression).}

\item{point_size}{Point size on the scatter plot.}

\item{scale_bar}{Length of the scale bad in microns.}
}
\value{
Returns a plot with cells shown as points and color indicating the genes it expresses.
}
\description{
Plots gene expression and cross-expression on tissue by coloring cells.
}
\examples{
data("locations")
data("expression")
locations  = as.matrix(locations)
expression = as.matrix(expression)
expression = expression[,1:5]
tissue_expression_plot(data = expression, locations = locations, gene1 = "Calb1", gene2 = "Rasgrf2")

}
