% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameCohort.R
\name{renameCohort}
\alias{renameCohort}
\title{Utility function to change the name of a cohort.}
\usage{
renameCohort(cohort, newCohortName, cohortId = NULL)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{newCohortName}{Character vector with same}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}
}
\value{
A cohort_table object.
}
\description{
Utility function to change the name of a cohort.
}
\examples{
\donttest{
library(CohortConstructor)
if(isTRUE(omock::isMockDatasetDownloaded("GiBleed"))){
cdm <- mockCohortConstructor()

settings(cdm$cohort1)

cdm$cohort1 <- cdm$cohort1 |>
  renameCohort(newCohortName = "new_name")

settings(cdm$cohort1)
}
}
}
