% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emaxmodel.R
\name{emaxmodel}
\alias{emaxmodel}
\title{Create an Emax or Imax model}
\usage{
emaxmodel(
  isPopulation = TRUE,
  checkBaseline = FALSE,
  checkFractional = FALSE,
  checkInhibitory = FALSE,
  checkSigmoid = FALSE,
  data = NULL,
  columnMap = TRUE,
  modelName = "",
  workingDir = "",
  ...
)
}
\arguments{
\item{isPopulation}{Is this a population model \code{TRUE} or individual model \code{FALSE}?}

\item{checkBaseline}{Set to \code{TRUE} if the model contains a baseline response.}

\item{checkFractional}{Set to \code{TRUE} to modify the default form for the model. Only applicable to models with \code{checkBaseline = TRUE}.}

\item{checkInhibitory}{Set to \code{TRUE} to change the model from an Emax to an Imax model.}

\item{checkSigmoid}{Set to \code{TRUE} to change the model to its corresponding signmoid form.}

\item{data}{Input dataset}

\item{columnMap}{If \code{TRUE} (default) column mapping arguments are required.
Set to \code{FALSE} to manually map columns after defining model using \code{\link{colMapping}}.}

\item{modelName}{Model name for subdirectory created for model output in current working directory.}

\item{workingDir}{Working directory to run the model. Current working directory will be used
if \code{workingDir} not specified.}

\item{...}{
  Arguments passed on to \code{\link[=emaxmodel_MappingParameters]{emaxmodel_MappingParameters}}
  \describe{
    \item{\code{ID}}{Column mapping argument for input dataset column(s)
that identify individual data profiles. Only applicable to population models
\code{isPopulation = TRUE}.}
    \item{\code{C}}{Column mapping argument that represents
the input dataset column for the independent variable that is treated
as a covariate during the estimation/simulation process.}
    \item{\code{EObs}}{Column mapping argument that represents
the input dataset column for the observed drug effect
(i.e., the dependent variable).}
  }}
}
\value{
\code{NlmePmlModel} object
}
\description{
Use to create an Emax or Imax model
}
\section{Column mapping}{

Note that quoted and unquoted column names are supported. Please see \code{\link{colMapping}}.
}

\examples{
model <- emaxmodel(data = pkpdData, ID = "ID", C = "CObs", EObs = "EObs")

model <- emaxmodel(
  checkBaseline = TRUE,
  checkFractional = TRUE,
  checkInhibitory = TRUE,
  data = pkpdData,
  ID = "ID",
  C = "CObs",
  EObs = "EObs"
)

# View PML Code
print(model)

}
