% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvalTrainIndices.R
\name{EvalTrainIndices}
\alias{EvalTrainIndices}
\title{Generate Training and Evaluation Indices for Cross-Validation}
\usage{
EvalTrainIndices(
  eval.method,
  sample.length,
  sample.length_cor,
  k = 1,
  tail.out = TRUE
)
}
\arguments{
\item{eval.method}{Character. The cross-validation method. Options include:
-\code{leave-k-out}: Leaves out \code{k} points at a time for evaluation.
-\code{retrospective}: Uses past data for training and a future point for evaluation.
-\code{in-sample}: Uses the entire dataset for both training and evaluation.
-\code{hindcast-vs-forecast}: Uses all years from the hindcast sdate dimension
 as training and all years from the forecast sdate dimension will be corrected.}

\item{sample.length}{Integer. Length of the sample (in years).}

\item{sample.length_cor}{Integer. Length of forecast sample (in years) in
\code{hindcast-vs-forecast} method.}

\item{k}{Positive integer. Default = 1.
In method \code{leave-k-out}, \code{k} is expected to be odd integer, 
indicating the number of points to leave out.
In method \code{retrospective}, \code{k} can be any positive integer, 
indicating when to start.}

\item{tail.out}{Logical for method \code{leave-k-out}. Default = TRUE.
TRUE to remove both extremes keeping the same sample size for all k-folds 
(e.g. sample.length=50, k=3, eval.dexes=1, train.dexes=(3,49)). 
FALSE to remove only the corresponding tail 
(e.g. sample.length=50, k=3, eval.dexes=1, train.dexes=(3,50))}
}
\value{
A list of lists, where each element contains:
  \code{eval.dexes}: Indices of evaluation points.
  \code{train.dexes}: Indices of training points.
}
\description{
This function generates training and evaluation indices based on different
cross-validation methods.
}
\examples{
# Leave-k-out cross-validation
EvalTrainIndices("leave-k-out", sample.length = 10, sample.length_cor = 5, k = 3)
# Retrospective cross-validation
EvalTrainIndices("retrospective", sample.length = 10, sample.length_cor = 5, k = 3)
# In-sample validation
EvalTrainIndices("in-sample", sample.length = 10, sample.length_cor = 5)
# Hindcast vs. Forecast validation
EvalTrainIndices("hindcast-vs-forecast", sample.length = 10, sample.length_cor = 5)

}
\author{
Theertha Kariyathan, \email{theertha.kariyathan@bsc.es}
}
