% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergeRefToExp.R
\name{MergeRefToExp}
\alias{MergeRefToExp}
\title{Merge a Reference To Experiments}
\usage{
MergeRefToExp(
  data1,
  data2,
  dates1 = NULL,
  dates2 = NULL,
  start1 = NULL,
  end1 = NULL,
  start2 = NULL,
  end2 = NULL,
  time_dim = "time",
  memb_dim = "member",
  ncores = NULL
)
}
\arguments{
\item{data1}{A multidimensional array with named dimensions. All dimensions 
must be equal to 'data2' dimensions except for the ones specified with 
'memb_dim' and 'time_dim'.}

\item{data2}{A multidimensional array of named dimensions matching the 
dimensions of parameter 'data1'. All dimensions must be equal to 'data1' 
except for the ones specified with 'memb_dim' and 'time_dim'.}

\item{dates1}{A multidimensional array of dates with named dimensions matching 
the temporal dimensions of parameter 'data1'. The common dimensions must be 
equal to 'data1' dimensions.}

\item{dates2}{A multidimensional array of dates with named dimensions matching 
the temporal dimensions on parameter 'data2'. The common dimensions must be 
equal to 'data2' dimensions.}

\item{start1}{A list to define the initial date of the period to select from 
'data1' by providing a list of two elements: the initial date of the period 
and the initial month of the period. The initial date of the period must be 
included in the 'dates1' array.}

\item{end1}{A list to define the final date of the period to select from 
'data1' by providing a list of two elements: the final day of the period and 
the final month of the period. The final date of the period must be 
included in the 'dates1' array.}

\item{start2}{A list to define the initial date of the period to select from 
'data2' by providing a list of two elements: the initial date of the period 
and the initial month of the period. The initial date of the period must be 
included in the 'dates2' array.}

\item{end2}{A list to define the final date of the period to select from 
'data2' by providing a list of two elements: the final day of the period and 
the final month of the period. The final date of the period must be 
included in the 'dates2' array.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension that will be used to combine the two arrays. By default, it is set 
to 'time'. Also, it will be used to subset the data in a requested 
period.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. If the 'data1' and 'data2' have no member dimension, set it as 
NULL. It is set as 'member' by default.}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array created from the combination of 'data1' and 
'data2'. The resulting array will contain the following dimensions: the 
original dimensions of the input data, which are common to both arrays and for 
the 'time_dim' dimension, the sum of the corresponding dimension of 'data1' 
and 'data2'. If 'memb_dim' is not null, regarding member dimension, two 
different situations can occur: (1) in the case that one of the arrays does 
not have member dimension or is equal to 1 and the other array has multiple 
member dimension, the result will contain the repeated values of the array one 
up to the lenght of member dimension of array two; (2) in the case that both 
arrays have member dimension and is greater than 1, all combinations of member 
dimension will be returned.
}
\description{
Some indicators are defined for specific temporal periods (e.g.: summer from 
June 21st to September 21st). If the initialization forecast date is later 
than the one required for the indicator (e.g.: July 1st), the user may want to 
merge past observations, or other references, to the forecast (or hindcast) to 
compute the indicator. If the forecast simulation doesn't cover the required 
period because it is initialized too early (e.g.: Initialization on November 
1st the forecast covers until the beginning of June next year), a climatology 
(or other references) could be added at the end of the forecast lead time to 
cover the desired period (e.g.: until the end of summer).
}
\details{
This function is created to merge observations and forecasts, known as the 
‘blending’ strategy (see references). The basis for this strategy is that the 
predictions are progressively replaced with observational data as soon as they 
become available (i.e., when entering the indicator definition period). This 
key strategy aims to increase users’ confidence in the reformed predictions.
}
\examples{
data_dates <- c(seq(as.Date("01-07-1993", "\%d-\%m-\%Y", tz = 'UTC'),
                   as.Date("01-12-1993","\%d-\%m-\%Y", tz = 'UTC'), "day"),
               seq(as.Date("01-07-1994", "\%d-\%m-\%Y", tz = 'UTC'),
                   as.Date("01-12-1994","\%d-\%m-\%Y", tz = 'UTC'), "day"))
dim(data_dates) <- c(time = 154, sdate = 2)
ref_dates <- seq(as.Date("01-01-1993", "\%d-\%m-\%Y", tz = 'UTC'),
                as.Date("01-12-1994","\%d-\%m-\%Y", tz = 'UTC'), "day")
dim(ref_dates) <- c(time = 350, sdate = 2)
ref <- array(1001:1700, c(time = 350, sdate = 2))
data <- array(1:(2*154*2), c(time = 154, sdate = 2, member = 2))
new_data <- MergeRefToExp(data1 = ref, dates1 = ref_dates, start1 = list(21, 6),
                         end1 = list(30, 6), data2 = data, dates2 = data_dates,
                         start2 = list(1, 7), end = list(21, 9), 
                         time_dim = 'time')

}
\references{
Chou, C., R. Marcos-Matamoros, L. Palma Garcia, N. Pérez-Zanón, 
M. Teixeira, S. Silva, N. Fontes, A. Graça, A. Dell'Aquila, S. Calmanti and 
N. González-Reviriego (2023). Advanced seasonal predictions for vine 
management based on bioclimatic indicators tailored to the wine sector. 
Climate Services, 30, 100343, \doi{10.1016/j.cliser.2023.100343}.
}
