% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeasonalFilter.R
\name{SeasonalFilter}
\alias{SeasonalFilter}
\title{Filter image catalog for seasonal images}
\usage{
SeasonalFilter(catalog, from, to)
}
\arguments{
\item{catalog}{\code{data.frame} or \code{sf} object as the one produced by a call to \code{SearchCatalog}}

\item{from}{start of the season of interest.}

\item{to}{end of the season of interest.

The \code{from} and \code{to} arguments can be either Date or character that can be converted to date by \code{as.Date}.
    Open intervals are not allowed (both \code{from} and \code{to} must be valid dates).}
}
\value{
A \code{data.frame} or a \code{sf} object, depending on the type of the input.
}
\description{
Filters image catalog entries that fall in the season of interest -
   dates between \code{from} day/month and \code{to} day/month for all years in the
   \code{from} - \code{to} time range.
}
\examples{
\dontrun{
dsn <- system.file("extdata", "centralpark.geojson", package = "CDSE")
aoi <- sf::read_sf(dsn, as_tibble = FALSE)
all_images <- SearchCatalog(aoi = aoi, from = "2021-06-01", to = "2023-08-31",
    collection = "sentinel-2-l2a", with_geometry = TRUE, client = OAuthClient)
sesonal_images <- SeasonalFilter(all_images, from = "2021-06-01", to = "2023-08-31")
}
}
\seealso{
\code{\link[CDSE]{SearchCatalog}}, \code{\link[CDSE]{SeasonalTimerange}}
}
