% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Point2Bbox.R
\name{Point2Bbox}
\alias{Point2Bbox}
\title{Create bounding box around a point}
\usage{
Point2Bbox(x, y = NULL, size, crs = 4326)
}
\arguments{
\item{x}{an \code{sf}, \code{sfc}, or \code{SpatialPoints*} object, a numeric indicating the longitude/easting of the point(s),
or any input accepted by \code{xy.coords}}

\item{y}{numeric, the latitude/northing of the point(s). Default: NULL}

\item{size}{numeric indicating the size (in meters) of the bounding box to create}

\item{crs}{coordinate reference system of the input (and the output): object of class \code{crs},
or input string for \code{st_crs}. Default: 4326 (WGS 84)}
}
\value{
A bounding box (numeric vector of length four), or a list of bounding boxes if the input is not scalar.
}
\description{
Creates the bounding box (numeric vector of length four) around the input point(s).
}
\details{
The function assumes that the \code{crs} units are either degrees or meters, a warning is issued if not,
    and the result will probably be incorrect.
}
\examples{
\dontrun{
Point2Bbox(x = -73.96557, y = 40.78246, size = 1000, crs = 4326)
}
}
\seealso{
\code{\link[grDevices]{xy.coords}}, \code{\link[sf]{st_crs}}
}
