% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{build_formula}
\alias{build_formula}
\title{Build an expanded formula with poly and interaction terms}
\usage{
build_formula(formula, poly_terms = NULL, interaction_terms = NULL)
}
\arguments{
\item{formula}{A base formula in the format Y ~ X | Z1 + Z2}

\item{poly_terms}{Character vector of polynomial term names}

\item{interaction_terms}{Character vector of interaction term names}
}
\value{
A formula object combining all terms
}
\description{
Build an expanded formula with poly and interaction terms
}
\examples{
poly_terms <- c("Z1_d_2", "Z2_d_2")
interaction_terms <- c("Z1_int_Z2")
formula <- Y ~ X | Z1 + Z2
final_formula <- build_formula(formula, poly_terms, interaction_terms)
print(final_formula)
}
