% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{projection_mean}
\alias{projection_mean}
\title{Projecting Posterior Means of Full-Model Coefficients onto a Reduced Subset Model}
\usage{
projection_mean(X_arr, beta1_mat, xs_vec, sigma2, alpha1_vec = NULL)
}
\arguments{
\item{X_arr}{A 3-D array of predictors, of dimension \code{D * n * p}.}

\item{beta1_mat}{A \code{D * p} matrix of full-model coefficients, one row per imputation.}

\item{xs_vec}{Logical vector of length \code{p}; \code{TRUE} for predictors to keep in the submodel.}

\item{sigma2}{Numeric scalar; the residual variance from the full model (pooled across imputations).}

\item{alpha1_vec}{Optional numeric vector of length \code{D}; full-model intercepts per imputation.
If \code{NULL} (the default), the projection omits an intercept term.}
}
\value{
A list with components:
\describe{
\item{\code{beta2_mat}}{A \code{D * p} matrix of projected submodel coefficients.}
\item{\code{alpha2_vec}}{(If \code{alpha1_vec} provided) numeric vector length \code{D} of projected intercepts.}
}
}
\description{
Given posterior means of \code{beta1_mat} (and optional intercepts
\code{alpha1_vec}) from a full model fitted on \code{D} imputed
datasets, compute the predictive projection onto the submodel defined by
\code{xs_vec}.  Returns the projected coefficients (and intercepts, if requested).
}
\examples{
# Simulate a single imputation with n=50, p=5:
D <- 3; n <- 50; p <- 5
X_arr <- array(rnorm(D * n * p), c(D, n, p))
beta1_mat <- matrix(rnorm(D * p), nrow = D)
# Suppose full-model sigma2 pooled is 1.2
sigma2 <- 1.2
# Project onto predictors 1 and 4 only:
xs_vec <- c(TRUE, FALSE, FALSE, TRUE, FALSE)
proj <- projection_mean(X_arr, beta1_mat, xs_vec, sigma2)
str(proj)

# With intercept:
alpha1_vec <- rnorm(D)
proj2 <- projection_mean(X_arr, beta1_mat, xs_vec, sigma2, alpha1_vec)
str(proj2)

}
