% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{delete_storage_account}
\alias{delete_storage_account}
\title{Delete an Azure storage account}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{delete_storage_account(name, confirm=TRUE, wait=FALSE)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the storage account.
\item \code{confirm}: Whether to ask for confirmation before deleting.
\item \code{wait}: Whether to wait until the deletion is complete.
}
}

\section{Value}{

NULL on successful deletion.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# delete a storage account
rg$delete_storage_account("mystorage")

}
}
\seealso{
\link{create_storage_account}, \link{get_storage_account}, \link{az_storage},
\href{https://learn.microsoft.com/en-us/rest/api/storagerp/}{Azure Storage Provider API reference}
}
